<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include('config.php');

// Get input from request body
$input = json_decode(file_get_contents("php://input"), true);
$email = $input['email'] ?? null;

if (!$email) {
    echo json_encode(['success' => false, 'message' => 'IB email is required']);
    exit;
}

// Update commission_status to 1 (enabled)
$stmt = $conn->prepare("UPDATE loginusers SET commission_status = 1 WHERE email = ?");
$stmt->bind_param("s", $email);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'IB commission enabled successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to enable IB commission']);
}

$stmt->close();
?>
